#ifdef _WIN32
#include <windows.h>
#endif
 
#include <gl/gl.h>
#include <gl/glut.h>
 
void display( void )
{
  /* clear all pixels */
 
  glClear( GL_COLOR_BUFFER_BIT );
 
  /* Draw white polygon (rectangle) with corners at
   * (0.25, 0.25, 0) and (0.75, 0.75, 0.0)
   */
 
   glColor3f( 1.0, 1.0, 1.0 );
   glBegin( GL_POLYGON );
     glVertex3f( 0.25, 0.25, 0.0 );
     glVertex3f( 0.75, 0.25, 0.0 );
     glVertex3f( 0.75, 0.75, 0.0 );
     glVertex3f( 0.25, 0.75, 0.0 );
   glEnd();
 
   /* don't wait
    * start processing buffered OpenGL routines
    */
 
   glFlush();
}
 
void init(void )
{
  /* select clearing (background) color */
  glClearColor( 0.0, 0.0, 0.0, 0.0 );
 
  /* initialize viewing values */
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glOrtho( 0.0, 1.0, 0.0, 1.0, -1.0, 1.0 );
}
 
int main(int argc, char* argv[])
{
  glutInit( &argc, (char **) argv );
  glutInitDisplayMode( GLUT_SINGLE | GLUT_RGB );
  glutInitWindowSize( 250, 250 );
  glutInitWindowPosition( 100, 100 );
  glutCreateWindow( "hello" );
 
  init();
 
  glutDisplayFunc( display );
  glutMainLoop();
 
  return 0;
}