#include "teststack.h"
#include "stack.h"

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

CPPUNIT_TEST_SUITE_REGISTRATION( TestStack );

void TestStack::TestStackSize(void)
{
  Stack stack( 10 );

  CPPUNIT_ASSERT_EQUAL( 10u, stack.GetSize() );
  CPPUNIT_ASSERT_EQUAL(  0u, stack.GetUsed() );
}

void TestStack::TestStackPush(void)
{
  Stack stack( 10 );

  CPPUNIT_ASSERT_EQUAL( 0u,   stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 1 ) );
  CPPUNIT_ASSERT_EQUAL( 1u,   stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 2 ) );
  CPPUNIT_ASSERT_EQUAL( 2u,   stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 3 ) );
  CPPUNIT_ASSERT_EQUAL( 3u,   stack.GetUsed() );
}

void TestStack::TestStackPop(void)
{
  Stack stack( 10 );

  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 1 ) );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 2 ) );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 3 ) );

  unsigned int value;
  CPPUNIT_ASSERT_EQUAL( 3u,  stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Pop( value ) );
  CPPUNIT_ASSERT_EQUAL( 3u,  value );

  CPPUNIT_ASSERT_EQUAL( 2u,  stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Pop( value ) );
  CPPUNIT_ASSERT_EQUAL( 2u,  value );

  CPPUNIT_ASSERT_EQUAL( 1u,  stack.GetUsed() );
  CPPUNIT_ASSERT_EQUAL( true, stack.Pop( value ) );
  CPPUNIT_ASSERT_EQUAL( 1u,  value );
  CPPUNIT_ASSERT_EQUAL( 0u,  stack.GetUsed() );
}

void TestStack::TestStackBuffer(void)
{
  Stack stack( 10 );

  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 1 ) );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 2 ) );
  CPPUNIT_ASSERT_EQUAL( true, stack.Push( 3 ) );

  CPPUNIT_ASSERT_EQUAL( 1u, stack.GetBuffer()[ 0 ] );
  CPPUNIT_ASSERT_EQUAL( 2u, stack.GetBuffer()[ 1 ] );
  CPPUNIT_ASSERT_EQUAL( 3u, stack.GetBuffer()[ 2 ] );
}
