#include "file.h"

File::File( char const * filename )
{
  Handle = fopen( filename, "r+" );
  Filename = filename;
  
  if( Handle )
  {
    fseek( Handle, 0, SEEK_END );
    Size = ftell( Handle );
    fseek( Handle, 0, SEEK_SET );
  }
}

File::~File()
{
  Close();
}

bool File::Read( char * buffer, int size )
{
  if( Handle )
    return 1 == fread( buffer, size, 1, Handle ); 
    
  return false;
}

bool File::Write( char * buffer, int size )
{
  if( Handle )
    return 1 == fwrite( buffer, size, 1, Handle );
    
  return false;
}
  
bool File::Close()
{
  if( Handle )
  {
  	fclose( Handle );
  	Handle = NULL;
  	return true;
  }
  
  return false;
}
